/*************************************************************************

*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2012 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.

**************************************************************************/

function getDocType()
{
	if( dw.getDocumentDOM() && dw.getDocumentDOM().getIsXHTMLDocument() )
	{
		return("XHTML");
	}
	else
	{
		return("HTML");
	}	
}

function removeChildTagEdit(childTag, parentTag)
{
	if( parentTag )
	{
		var childNodes = parentTag.getChildNodes();
		var newChildNodes = new Array();
		
		if(childNodes && newChildNodes)
		{
			for(var i=0 ; i<childNodes.length; i++)
			{
				if( childNodes[i] != childTag )
				{
					newChildNodes.push(childNodes[i]);
				}
			}
            return newChildNodes;
		}
	}
    return null;
	
}

function getChildId(theObj, parent)
{
	var ret = -1;
	if(parent && theObj)
	{
		var childNodes = parent.childNodes; 
		if(childNodes)
		{
			for(var i=0 ; i<childNodes.length ; i++ )
			{
				if( childNodes[i]==	theObj )
				{
					ret = i;
					break;
				}
					
			}
		}
	}
	return ret;
}

function removeSelectedNodeFromParent()
{
	var theDOM = dw.getDocumentDOM(); 
	if( theDOM )
	{
    	var theObj = theDOM.getSelectedNode();
		if( theObj ){
			var selectedNode = new TagEdit( theObj.outerHTML);
			var parent = theObj.parentNode;
			
			if(parent)
			{
				var childIdToRemove = getChildId(theObj, parent);
				if(childIdToRemove > -1 )
				{
					var parentNode = new TagEdit( parent.outerHTML);
					var childNodes = parentNode.getChildNodes();
					var newChildNodes = new Array();
					if(childNodes && newChildNodes)
					{ 					
						for(var i=0 ; i<childNodes.length; i++)
						{
							if( i!= childIdToRemove )
							{
								newChildNodes.push(childNodes[i]);
							}							
						}
						parentNode.setChildNodes(newChildNodes);
						parent.outerHTML = parentNode.getOuterHTML();
					}
				}
			}
		}
	}		
}